/*
 * Decompiled with CFR 0.152.
 */
package jeresources.registry;

import java.util.HashSet;
import java.util.Set;
import jeresources.entry.EnchantmentEntry;
import jeresources.platform.Services;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_7923;

public class EnchantmentRegistry {
    private Set<EnchantmentEntry> enchantments = new HashSet<EnchantmentEntry>();
    private static EnchantmentRegistry instance;

    public static EnchantmentRegistry getInstance() {
        if (instance == null) {
            instance = new EnchantmentRegistry();
            return instance;
        }
        return instance;
    }

    public EnchantmentRegistry() {
        for (class_1887 enchantment : EnchantmentRegistry.getEnchants()) {
            if (enchantment == null) continue;
            this.enchantments.add(new EnchantmentEntry(enchantment));
        }
    }

    public Set<EnchantmentEntry> getEnchantments(class_1799 itemStack) {
        HashSet<EnchantmentEntry> set = new HashSet<EnchantmentEntry>();
        for (EnchantmentEntry enchantmentEntry : this.enchantments) {
            class_1887 enchantment = enchantmentEntry.getEnchantment();
            if (itemStack.method_7909() == class_1802.field_8529 && Services.PLATFORM.isAllowedOnBooks(enchantment)) {
                set.add(enchantmentEntry);
                continue;
            }
            if (!enchantment.method_8192(itemStack) || !class_1890.method_8201(class_1890.method_8222((class_1799)itemStack).keySet(), (class_1887)enchantment)) continue;
            set.add(enchantmentEntry);
        }
        return set;
    }

    private void excludeFormRegistry(class_1887 enchantment) {
        this.enchantments.removeIf(enchantmentEntry -> enchantmentEntry.getEnchantment().method_8184().toString().equals(enchantment.method_8184()));
    }

    private void excludeFormRegistry(String sEnchantment) {
        for (class_1887 enchantment : EnchantmentRegistry.getEnchants()) {
            if (enchantment == null || !enchantment.method_8184().toLowerCase().contains(sEnchantment.toLowerCase())) continue;
            this.excludeFormRegistry(enchantment);
        }
    }

    public void removeAll(String[] excludedEnchants) {
        for (String enchant : excludedEnchants) {
            this.excludeFormRegistry(enchant);
        }
    }

    private static Iterable<class_1887> getEnchants() {
        return class_7923.field_41176;
    }
}

